require 'g_level'
g_level.reset()

--params
island_show_time = 20
perfect_garden_show_time = 10
fade_time = 4


--SET 1 the park end
if parameter == 0 then

    --INIT TEXTURES  init all textures here.
    h = FM_NEAREST;
    lua_init_texture("island", "data/images/cutscene/saari.png", h, WM_REPEAT,WM_CLAMP,AM_MODULATE)
    lua_init_texture("fade", "data/images/effects/black.png", h, WM_REPEAT,WM_CLAMP,AM_MODULATE)
    lua_init_texture("garden_end", "data/images/cutscene/park-end.png", h, WM_REPEAT,WM_CLAMP,AM_MODULATE)

    -- Create Level
    g_level.reset()
    lua:create_level(1.0,1.0,1.0,1.0)   --RGBA values are given also
    lua:create_layer(0.0,0.0,BM_DEFAULT)  -- x_scroll , y_scroll, blendmode  -- 0
    lua:create_layer(1.0,1.0,BM_DEFAULT) -- 1 --physics layer
    lua:create_layer(1.0,1.0,BM_DEFAULT) -- 2
    lua:create_layer(0.0,0.0,BM_DEFAULT) -- 3 --dummy

    -- Island
    local scale = 0.8
    lua:create_sprite("garden_end", ST_TEXTURED,"garden_end",           0.0, 0.0) 
    lua:sprite_shape("garden_end",ST_TEXTURED,                          scale * 2340.0/2, scale * 1170.0/2)
    lua:textured_sprite_tex_coords("garden_end", ST_TEXTURED,           0.0, 0.0, 1.0, 1.0)
    lua:remorfable_sprite("remo1", "garden_end", time_to_remo_speed(island_show_time), false)             -- name, sprite_name, speed, repeat
    
    lua:add_key_frame(1.0, 0.0, 0.0, 0.0, 0.8)  -- adds a new key frame. time, x, y, rotation, scale
    lua:add_key_frame_color(1.0,1.0,1.0,1.0)  -- r,g,b,a
    lua:upload_key_frame("remo1")

    g_level.upload("remo1",0)
    
    --text
    local x = 0.0
    local y = 250.0
    lua:create_text("tuomo","comic_sans",x,y,0.2,0.6) --name, font, x,y, delay, scale
    lua:text_color("tuomo",1.0,1.0,1.0,1.0)  --name, r,g,b,a
    lua:add_text("tuomo", "Yes... It never goes by the book...")
    lua:remorfable_sprite("remo", "tuomo", time_to_remo_speed(island_show_time-fade_time), false)             -- name, sprite_name, speed, repeat

    lua:add_key_frame(0.9, x, y, 0.0, 0.7)  -- adds a new key frame. time, x, y, rotation, scale
    lua:add_key_frame_color(1.0,1.0,1.0,1.0)  -- r,g,b,a
    lua:upload_key_frame("remo")
    lua:add_key_frame(1.0, x, y, 0.0, 0.7)  -- adds a new key frame. time, x, y, rotation, scale
    lua:add_key_frame_color(1.0,1.0,1.0,0.0)  -- r,g,b,a
    lua:upload_key_frame("remo")

    g_level.upload("remo",1)
    lua:gameobject_remove_from_temp_list( "tuomo" )
    --text
    
    fade_in(fade_time) --time

    timer_adv(island_show_time,"data/scripts/lvl_outro.lua",false, 11) -- time, script, is_repeat, id
    lua:set_game_state(GS_FREEZE) -- sets the game state to menu. thus you are able to use the menu commands
    
elseif parameter == 11 then    
    timer_adv(1.99,"data/scripts/lvl_outro.lua",false, 1) -- time, script, is_repeat, id
    fade_out(fade_time)
------------------------------------------------------------------------
-- SET 2 Island
elseif parameter == 1 then
    -- Create Level
    g_level.reset()
    lua:create_level(1.0,1.0,1.0,1.0)   --RGBA values are given also
    lua:create_layer(0.0,0.0,BM_DEFAULT)  -- x_scroll , y_scroll, blendmode  -- 0
    lua:create_layer(1.0,1.0,BM_DEFAULT) -- 1 --physics layer
    lua:create_layer(1.0,1.0,BM_DEFAULT) -- 2
    lua:create_layer(0.0,0.0,BM_DEFAULT) -- 3 --dummy
    
    --perfect garden
    local scale = 1.2
    lua:create_sprite("island", ST_TEXTURED,"island",                   0.0, 0.0) 
    lua:sprite_shape("island",ST_TEXTURED,                               scale * 2048.0/2, scale * 1024.0/2)
    lua:textured_sprite_tex_coords("island", ST_TEXTURED,                0.0, 0.0, 1.0, 1.0)    
    lua:remorfable_sprite("remo2", "island", time_to_remo_speed(perfect_garden_show_time), false)             -- name, sprite_name, speed, repeat
    
    lua:add_key_frame(1.0, 0.0, 0.0, 0.0, 0.8)  -- adds a new key frame. time, x, y, rotation, scale
    lua:add_key_frame_color(1.0,1.0,1.0,1.0)  -- r,g,b,a
    lua:upload_key_frame("remo2")

    g_level.upload("remo2",0)
    --perfection end
    
    --text
    local x = 0.0
    local y = 150.0
    lua:create_text("tuomo","comic_sans",x,y,0.2,0.6) --name, font, x,y, delay, scale
    lua:text_color("tuomo",1.0,1.0,1.0,1.0)  --name, r,g,b,a
    lua:add_text("tuomo", "The End")
    lua:remorfable_sprite("remo", "tuomo", time_to_remo_speed(perfect_garden_show_time-fade_time), false)             -- name, sprite_name, speed, repeat

    lua:add_key_frame(0.9, x, y, 0.0, 0.7)  -- adds a new key frame. time, x, y, rotation, scale
    lua:add_key_frame_color(1.0,1.0,1.0,1.0)  -- r,g,b,a
    lua:upload_key_frame("remo")
    lua:add_key_frame(1.0, x, y, 0.0, 0.7)  -- adds a new key frame. time, x, y, rotation, scale
    lua:add_key_frame_color(1.0,1.0,1.0,0.0)  -- r,g,b,a
    lua:upload_key_frame("remo")

    g_level.upload("remo",1)
    lua:gameobject_remove_from_temp_list( "tuomo" )
    --text
    
    --text
    local x = 0.0
    local y = 150.0
    lua:create_text("tuomo","comic_sans",x,y,0.2,0.7) --name, font, x,y, delay, scale
    lua:text_color("tuomo",1.0,1.0,1.0,1.0)  --name, r,g,b,a
    lua:remorfable_sprite("remo", "tuomo", time_to_remo_speed(perfect_garden_show_time-fade_time), false)             -- name, sprite_name, speed, repeat

    lua:add_key_frame(0.9, x, y, 0.0, 0.7)  -- adds a new key frame. time, x, y, rotation, scale
    lua:add_key_frame_color(1.0,1.0,1.0,1.0)  -- r,g,b,a
    lua:upload_key_frame("remo")
    
    lua:add_key_frame(1.0, x, y, 0.0, 0.7)  -- adds a new key frame. time, x, y, rotation, scale
    lua:add_key_frame_color(1.0,1.0,1.0,0.0)  -- r,g,b,a
    lua:upload_key_frame("remo")

    --g_level.upload("remo",1)
    lua:gameobject_remove_from_temp_list( "tuomo" )
    --text
    
    fade_in(fade_time)

    timer_adv(perfect_garden_show_time,"data/scripts/lvl_outro.lua",false,12) -- time, script,is_repeat, id
    lua:set_game_state(GS_FREEZE) -- sets the game state to menu. thus you are able to use the menu commands
            
elseif parameter == 12 then    
    timer_adv(1.99,"data/scripts/lvl_credits.lua",false, 2) -- time, script, is_repeat, id
    fade_out(fade_time)
end